﻿//============================================
// filename: main.c
// chip    : CSU38F20
// author  :
// date    : 2020-12-07
//============================================
#include "CSU38F20.h"
#include "wwdt.h"

//============================================
// interrupt function
//============================================
void INT_FUNCTION(void) interrupt
{

}

//============================================
// program start
//============================================
void main()
{
	unsigned char wwdt_cnt = 0;
	PT1EN_0 = 1;
	PT1PU_0 = 0;
	PT1CON0 = 0;
	PT1_0 = 1;
	wwdt_init();	//窗口值上限为0x5E，下限为0x3F，每Tcpuclk*12288 = 3ms计数减1
	while(1)
	{
		wwdt_cnt = WWDTCR;
		wwdt_cnt &= 0x7f;
		if(wwdt_cnt < WWDT_RATE)
		{
			wwdt_set_count();	//在窗口期喂狗，填充0x7F
		}
		 asm("nop");
	}
}
